/**
 * \file: util_lib_i.h
 *
 * \version: $Id: util_lib_i.h,v 1.11 2011/09/30 10:58:34 smaleyka Exp $
 *
 * This header file declares the basic types that are to be used for
 * programming on the ADIT platform.

 * \component: global definition file
 *
 * \author: T. Polle <tpolle(o)de.adit-jv.com>
 *
 * \copyright: (c) 2003 - 2008 ADIT Corporation
 *
 */
#ifndef __UTIL_LIB_I_H_
#define __UTIL_LIB_I_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "util_lib.h"

#define UTIL_ADUTIL          ((S8*)"ADUTIL")
#define UTIL_SC_TBL          ((S8*)"ADUTIL_SC_TBL")

/**
 * \brief Read the contents of the thread register 2.
 *
 * \return          VP  contents of the thread register 2.
 */
IMPORT VP UTIL_get_threadid2(void);

/**
 * \brief Initialise utility as static constructor.
 *
 * \return          E_OK, if the initialisation was successful,
 *                  else, T-Kernel error code.
 */
IMPORT S32 UTIL_lib_init(void);

#ifdef __cplusplus
};
#endif

#endif /* __UTIL_LIB_I_H_ */
